IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL')
Begin
CREATE TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL](
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_CLASS_FISC] [int] NOT NULL,
	[CD_REGIAO_FISCAL] [int] NOT NULL,
 CONSTRAINT [PK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PROD] ASC,
	[CD_CLASS_FISC] ASC,
	[CD_REGIAO_FISCAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PROD] ASC,
	[CD_REGIAO_FISCAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] ADD  CONSTRAINT [DF_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] ADD  CONSTRAINT [DF_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] ADD  CONSTRAINT [DF_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_CD_CLASS_FISC]  DEFAULT ((0)) FOR [CD_CLASS_FISC]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] ADD  CONSTRAINT [DF_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_CD_REGIAO_FISCAL]  DEFAULT ((0)) FOR [CD_REGIAO_FISCAL]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] CHECK CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_EST_PROD]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_EST_TRIB_CLASS_FISC] FOREIGN KEY([CD_CLASS_FISC])
REFERENCES [dbo].[EST_TRIB_CLASS_FISC] ([CD_CLASS_FISC])

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] CHECK CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_EST_TRIB_CLASS_FISC]

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_PRC_REGIAO_FISCAL] FOREIGN KEY([CD_REGIAO_FISCAL])
REFERENCES [dbo].[PRC_REGIAO_FISCAL] ([CD_REGIAO_FISCAL])

ALTER TABLE [dbo].[EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL] CHECK CONSTRAINT [FK_EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL_PRC_REGIAO_FISCAL]
end